Battle.prototype.draw = function()
{
	this.drawGraphics(); // Draws background and sprites
	if (this.currentEffect != undefined)
	{
		this.currentEffect.draw();
	}
	for (var i = 0; i < this.list.length; i ++)
	{
		if (this.list[i].damage != undefined)
		{
			this.list[i].damage.draw(this.list[i].x, this.list[i].y);
		}
	}
	// Draw menu (if there is one) and enemy info
	if (this.menu.length > 0)
	{
		if (this.menu[this.menu.length - 1].displayMenus)
		{
			for (var i = 0; i < this.menu.length; i ++)
			{
				this.menu[i].draw(18 + i * 6, 180 + i * 6, 4);
			}
		}
		else
		{
			this.menu[this.menu.length - 1].draw(18, 180, 4);
		}
	}
	if (this.message.length > 0)
	{
		if (this.message[0].speaker != undefined && this.message[0].speaker != "")
		{
			window.drawWindow(60, 14, 200, 22, "MESSAGE");
			font.drawText(60, 14, this.message[0].speaker);
			font.drawText(60, 26, "\"" + this.message[0].text + "\"");
		}
		else
		{
			window.drawWindow(60, 14, 200, 10, "MESSAGE");
			if (this.message[0].icon != undefined)
			{
				font.iconText(160, 14, this.message[0].text, this.message[0].icon, "center");
			}
			else
				font.drawText(160, 14, this.message[0].text, "center");
		}
	}
	else
	{
		// Draw character overlays
		for (var i = 0; i < this.party.length; i ++)
		{
			drawCharacterInfo(16 + i * 70, 6, this.party[i]);
		}
	}
}

Battle.prototype.drawGraphics = function()
{
	// Draw background
	this.background.blit(0, 0);
	// Draw sprites
	for (var i = 0; i < this.list.length; i ++)
	{
		this.list[i].sprite.draw(this.list[i].x, this.list[i].y);
		this.list[i].sprite.update();
	}
}

function drawCharacterInfo(x, y, character)
{
	GradientRectangle(x, y - 4, 49, 13, system.windowRight, system.windowRight, system.windowLeft, system.windowLeft);
	GradientRectangle(x + 49, y - 4, 13, 13, system.windowRight, system.windowRight, system.windowRight, system.windowLeft);
	GradientLineV(x, y - 4, 14, colors.blank, colors.black);
	GradientLineV(x, y + 10, 28, colors.black, colors.blank);
	Line(x + 1, y + 9, x + 49, y + 9, colors.black);
	GradientLineH(x + 50, y + 9, 13, colors.black, colors.blank);
	font.drawText(x + 3, y, character.name);
	GradientRectangle(x + 1, y + 10, 49, 28, system.windowLeft, system.windowLeft, system.windowRight, system.windowRight);
	GradientRectangle(x + 50, y + 10, 13, 28, system.windowLeft, system.windowRight, system.windowRight, system.windowRight);
	switch (system.currentBattle.infoStyle)
	{
		case "HP":
			font.littleText(x + 2, y + 11, "HP", "left", colors.hp);
			font.littleText(x + 50, y + 10, character.hp, "right");
			gauge(x + 2, y + 18, 50, character.hp, character.hpmax, colors.hp);
			font.littleText(x + 50, y + 20, character.hpmax, "right");
			break;
		case "MP":
			font.littleText(x + 2, y + 11, "MP", "left", colors.mp);
			font.littleText(x + 50, y + 10, character.mp, "right");
			gauge(x + 2, y + 18, 50, character.mp, character.mpmax, colors.mp);
			font.littleText(x + 50, y + 20, character.mpmax, "right");
			break;
		case "Status":
			font.littleText(x + 2, y + 11, "STATUS");
			GradientLineH(x, y + 19, 30, colors.blank, colors.black);
			GradientLineH(x + 30, y + 19, 30, colors.black, colors.blank);
			// Draw status icons
			if (character.status["poison"])
			{
				graphics.images.battle.icons.poison.blit(x + 2, y + 23);
			}
			if (character.status["confuse"])
			{
			}
			break;
		case "Normal":
			font.littleText(x + 2, y + 11, "HP", "left", colors.hp);
			font.littleText(x + 50, y + 10, character.hp, "right");
			gauge(x + 2, y + 18, 50, character.hp, character.hpmax, colors.hp);
			font.littleText(x + 2, y + 21, "MP", "left", colors.mp);
			font.littleText(x + 50, y + 20, character.mp, "right");
			gauge(x + 2, y + 28, 50, character.mp, character.mpmax, colors.mp);
			break;
	}
	window.circle.blit(x - 3, y + 6);
}

function Sprite(fileName, direction)
{
	if (direction == undefined)
	{
		direction = "battle-stance";
	}
	this.sprite = LoadSpriteset(fileName);
	this.findDirection = function(direction)
	{
		for (var i = 0; i < this.sprite.directions.length; i ++)
		{
			if (this.sprite.directions[i].name == direction)
			{
				return i;
			}
		}
	}
	this.color = CreateColor(255, 255, 255, 255);
	this.scale = 1;
	this.degree = 0;
	this.currentFrame = 0;
	this.currentDirection = this.findDirection(direction);
	this.time = 0;
	this.loop = false;
}

Sprite.prototype.draw = function(x, y)
{
	var image = this.sprite.images[this.sprite.directions[this.currentDirection].frames[this.currentFrame].index];
	if (this.scale != 1)
	{
		x -= (image.width * this.scale - image.width) / 2;
		y -= (image.height * this.scale - image.height) / 2;
	}
	if (this.scale == 1 && this.degree == 0)
	{
		image.blitMask(x, y, this.color);
	}
	else if (this.degree == 0)
	{
		zoomBlitMask(image, x, y, this.scale, this.color);
	}
	else if (this.scale == 1)
	{
		rotateBlitMask(image, x, y, dtr(this.degree), this.color);
	}
	else
	{
		log.write("zoom Rotate Blit mask");
		zoomRotateBlitMask(image, x, y, this.scale, dtr(this.degree), this.color);
		log.write("Finished image");
	}
}

// Returns coordinates that damage counter is drawn at
Sprite.prototype.getCoordinates = function(x, y, cursor)
{
	if (cursor == undefined)
	{
		return new Array(x + this.sprite.base.x1 + ((this.sprite.base.x2 - this.sprite.base.x1 + 1) / 2), y + this.sprite.base.y2 + (this.sprite.base.y1 - this.sprite.base.y2 + 1) - 8);
	}
	else
		return new Array(x + this.sprite.base.x1 + 1, y + this.sprite.base.y2 + ((this.sprite.base.y1 - this.sprite.base.y2 + 1) / 2) - 8);
}

Sprite.prototype.update = function()
{
	if (this.time + (this.sprite.directions[this.currentDirection].frames[this.currentFrame].delay * 10) <= GetTime())
	{
		if (this.currentFrame < this.sprite.directions[this.currentDirection].frames.length - 1)
		{
			this.currentFrame ++;
		}
		else if (this.loop)
		{
			this.currentFrame = 0;
		}
		this.time = GetTime();
	}
}

Sprite.prototype.changeDirection = function(direction)
{
	this.currentDirection = this.findDirection(direction);
	this.currentFrame = 0;
}

Sprite.prototype.isFinished = function()
{
	if (this.loop)
	{
		return false;
	}
	else
	{
		if (this.currentFrame == this.sprite.directions[this.currentDirection].frames.length - 1)
		{
			return true;
		}
	}
}